/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/* Do issends with send and recv buffers of varying alignments. */
#include <stdio.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "test_common.h"

#define ONE_PAGE 4096
#define NUM_PAGES 25

void fill_buff(char *p, char ch, int length)
{
  int i;
  for (i = 0; i < length; ++i) {
    *p++ = ch;
  }
}

int check_buff(char *p, char ch, int length)
{
  int i;
  for (i = 0; i < length; ++i) {
    if (*p++ != ch) {
      break;
    }
  }
  return i;
}

int main(void)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char *send_buff_unaligned, *send_buff;
  char *recv_buff_unaligned, *recv_buff;
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  mx_request_t send_req;
  mx_request_t recv_req;
  mx_status_t status;
  mx_return_t ret;
  uint32_t result;
  int i;

  send_buff_unaligned = malloc(ONE_PAGE * (NUM_PAGES+2));
  recv_buff_unaligned = malloc(ONE_PAGE * (NUM_PAGES+2));
  send_buff = (char*)(((uintptr_t)send_buff_unaligned + (ONE_PAGE-1)) & ~(ONE_PAGE-1));
  recv_buff = (char*)(((uintptr_t)recv_buff_unaligned + (ONE_PAGE-1)) & ~(ONE_PAGE-1));
  
  printf("sbu %p sb %p\n", send_buff_unaligned, send_buff);
  printf("rbu %p rb %p\n", recv_buff_unaligned, recv_buff);

  ret = mx_init();
  insist(ret == MX_SUCCESS);
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  printf("send\n");
  /* Test sends of various alignments */
  for (i = 1; i < ONE_PAGE; i<<=1) {
    printf("%d\n", i);
    /* Misalign send. Setting of recv can be moved out of loop, but who
       really cares? */
    send_seg.segment_ptr = send_buff + i;
    send_seg.segment_length = ONE_PAGE * NUM_PAGES;
    recv_seg.segment_ptr = recv_buff;
    recv_seg.segment_length = ONE_PAGE * NUM_PAGES;

    /* Fill send buffer with sentinel, then real data. Fill recv buffer
       with sentinel. */
    fill_buff(send_buff_unaligned, 'a', ONE_PAGE * (NUM_PAGES+2));
    fill_buff(send_buff + i, 's', ONE_PAGE*NUM_PAGES);
    fill_buff(recv_buff_unaligned, 'b', ONE_PAGE * (NUM_PAGES+2));

    mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
    mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
    mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
    mx_wait(ep, &send_req, MX_INFINITE, &status, &result);

    if (check_buff(recv_buff_unaligned, 'b',
		   recv_buff - recv_buff_unaligned)
	!= (recv_buff - recv_buff_unaligned)) {
      printf("blah\n");
    }
    if (check_buff(recv_buff, 's', ONE_PAGE*NUM_PAGES) != ONE_PAGE*NUM_PAGES) {
      printf("blah blah\n");
    }
    if (check_buff(recv_buff+ONE_PAGE*NUM_PAGES, 'b', ((ONE_PAGE*(NUM_PAGES+2)) 
					       - (recv_buff - recv_buff_unaligned) - ONE_PAGE*NUM_PAGES))
	!= ((ONE_PAGE*(NUM_PAGES+2)) - (recv_buff - recv_buff_unaligned) - ONE_PAGE*NUM_PAGES)) {
      printf("blah blah blah\n");
    }
  }

  printf("recv\n");
  /* Test recvs of various alignments */
  for (i = 1; i < ONE_PAGE; i<<=1) {
    printf("%d\n", i);
    send_seg.segment_ptr = send_buff;
    send_seg.segment_length = ONE_PAGE * NUM_PAGES;
    recv_seg.segment_ptr = recv_buff + i;
    recv_seg.segment_length = ONE_PAGE * NUM_PAGES;

    fill_buff(send_buff_unaligned, 'a', ONE_PAGE * (NUM_PAGES+2));
    fill_buff(send_buff, 's', ONE_PAGE*NUM_PAGES);
    fill_buff(recv_buff_unaligned, 'b', ONE_PAGE * (NUM_PAGES+2));

    mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
    mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
    mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
    mx_wait(ep, &send_req, MX_INFINITE, &status, &result);
    
    if (check_buff(recv_buff_unaligned, 'b',
		   recv_buff - recv_buff_unaligned + i)
	!= (recv_buff - recv_buff_unaligned + i)) {
      printf("foo\n");
    }
    if (check_buff(recv_buff + i, 's', ONE_PAGE*NUM_PAGES) != ONE_PAGE*NUM_PAGES) {
      printf("foo foo\n");
    }
    if (check_buff(recv_buff + i + ONE_PAGE*NUM_PAGES, 'b',
		   ((ONE_PAGE*(NUM_PAGES+2))
		    - (recv_buff - recv_buff_unaligned)
		    - ONE_PAGE*NUM_PAGES
		    - i))
	!= ((ONE_PAGE*(NUM_PAGES+2))
	    - (recv_buff - recv_buff_unaligned)
	    - ONE_PAGE*NUM_PAGES
	    - i)) {
      printf("foo foo foo\n");
    }
  }
	

  free(send_buff_unaligned);
  free(recv_buff_unaligned);
  
  mx_close_endpoint(ep);
  mx_finalize();
  return 0;
}
